//+------------------------------------------------------------------+
//|                                                        |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2005, FX Sniper "
#property  link      "http://www.metaquotes.net/"

//---- indicator settings
#property  indicator_chart_window
#property  indicator_buffers 2

#property indicator_color1 White
#property indicator_color2 Red

double Buffer1[]; //White
double Buffer2[]; //Red

// User input
extern int Rperiod1 = 15;
extern int Rperiod2 = 30;
extern int Rperiod3 = 60;
extern int Draw4HowLong = 400;

//Static
double lsma0a;
double lsma1a;
double lsma0b;
double lsma1b;
double lsma0c;
double lsma1c;



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(6);
   
   // 233 up arrow
   // 234 down arrow
   // 159 big dot
   
   SetIndexBuffer(0,Buffer1);
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,233);  //up

   SetIndexBuffer(1,Buffer2);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,234);  //down
  }

int start()
  {
   int shift;
   int i;
   int dir3;
   
   for(shift = Draw4HowLong; shift >= 0; shift--)
     { 
      dir3=0;
      
      lsma1a=lsma0a;
      lsma1b=lsma0b;
      lsma1c=lsma0c;
      
      lsma0a = LSMA(Rperiod1,shift);
      lsma0b = LSMA(Rperiod2,shift);
      lsma0c = LSMA(Rperiod3,shift);
          
      if ( lsma1a > lsma0a ) dir3++;
      if ( lsma1b > lsma0b ) dir3++;
      if ( lsma1c > lsma0c ) dir3++;

      if ( lsma1a < lsma0a ) dir3--;
      if ( lsma1b < lsma0b ) dir3--;
      if ( lsma1c < lsma0c ) dir3--;


      Buffer1[shift]=CLR_NONE;//EMPTY_VALUE;
      Buffer2[shift]=CLR_NONE;//EMPTY_VALUE;
      if ( dir3 ==   3  ) Buffer2[shift]=High[shift];
      if ( dir3 == (-3) ) Buffer1[shift]=Low[shift];


     }
  }

double LSMA(int myLPeriod, int myShift )
  {
   int myI;
   double myLengthvar;
   double mySum=0;

   myLengthvar = myLPeriod + 1;
   myLengthvar /= 3;

   for(myI = myLPeriod; myI >= 1  ; myI--)
     {
      mySum += ( myI - myLengthvar)*Open[myLPeriod-myI+myShift];
     }
   return( mySum*6/(myLPeriod*(myLPeriod+1)) );
  }  
  

